function A_com = SVD_compression(A,k)  
% A is the original image, 
% k is the order of approximation,
% Ak is the compressed image of A.

B = double(A); % Convert A to double for later computation
B1 = B(:,:,1);
B2 = B(:,:,2);
B3 = B(:,:,3);

[U1,S1,V1] = svd(B1);
V4 = V1';
B(:,:,1) = U1(:,1:k)*S1(1:k,1:k)*V4(1:k,:);

[U2,S2,V2] = svd(B2);
V5 = V2';
B(:,:,2) = U2(:,1:k)*S2(1:k,1:k)*V5(1:k,:);

[U3,S3,V3] = svd(B3);
V6 = V3';
B(:,:,3) = U3(:,1:k)*S3(1:k,1:k)*V6(1:k,:);

A_com = uint8(B);
% Convert double back to uint8.

end

